#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), y(n);
    for (int i = 0; i < n; i++) cin >> x[i] >> y[i];

    vector<int> id(n);
    iota(id.begin(), id.end(), 0);

    vector<double> ang(n);
    for (int i = 0; i < n; i++) {
        ang[i] = atan2((double)y[i], (double)x[i]);
    }

    sort(id.begin(), id.end(), [&](int a, int b) {
        return ang[a] < ang[b];
    });

    vector<int> ord = id;
    for (int i = 0; i < n; i++) ord.push_back(id[i]);

    vector<long long> px(2*n), py(2*n);
    for (int i = 0; i < 2*n; i++) {
        px[i] = x[ord[i]];
        py[i] = y[ord[i]];
    }

    long long cx = 0, cy = 0;
    int l = 0;
    long long best = 0;
    int best_l = 0, best_r = -1;

    for (int r = 0; r < 2*n; r++) {
        cx += px[r];
        cy += py[r];

        while (l <= r) {
            long long nx = cx - px[l];
            long long ny = cy - py[l];
            if (nx*nx + ny*ny >= cx*cx + cy*cy) {
                cx = nx;
                cy = ny;
                l++;
            } else break;
        }

        long long cur = cx*cx + cy*cy;
        if (cur > best) {
            best = cur;
            best_l = l;
            best_r = r;
        }
    }

    vector<int> res;
    if (best_r >= best_l) {
        for (int i = best_l; i <= best_r; i++) {
            if (i < n) res.push_back(ord[i] + 1);
        }
    }

    cout << res.size() << "\n";
    for (int v : res) cout << v << " ";
    cout << "\n";

    return 0;
}